/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2022 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
import SearchInput from"../SearchTokenizer/SearchInput.js";class GLPIKanbanRights{constructor(e){this.create_item=e["create_item"]||false;this.delete_item=e["delete_item"]||false;this.create_column=e["create_column"]||false;this.modify_view=e["modify_view"]||false;this.create_card_limited_columns=e["create_card_limited_columns"]||[];this.order_card=e["order_card"]||false}canCreateItem(){return this.create_item}canDeleteItem(){return this.delete_item}canCreateColumn(){return this.create_column}canModifyView(){return this.modify_view}canOrderCard(){return this.order_card}getAllowedColumnsForNewCards(){return this.create_card_limited_columns}}(function(){window.GLPIKanban=function(){const e=this;this.element="";this.columns={};this.ajax_root=CFG_GLPI.root_doc+"/ajax/";this.max_team_images=3;this.team_image_size=24;this.item=null;this.supported_itemtypes={};this.rights=new GLPIKanbanRights({});this.allow_add_item=false;this.allow_delete_item=false;this.allow_create_column=false;this.allow_modify_view=false;this.limit_addcard_columns=[];this.allow_order_card=false;this.dark_theme=false;this.column_field={id:"",extra_fields:{}};this.show_toolbar=true;this.filters={_text:""};this.filter_tokenizer=null;this.supported_filters=[];this.add_column_form="";this.create_column_form="";this.team_badge_cache={User:{},Group:{},Supplier:{},Contact:{}};this.background_refresh_interval=0;let t=null;var n=null;this.user_state={is_dirty:false,state:{}};this.last_refresh=null;this.is_sorting_active=false;this.sort_data=undefined;this.mutation_observer=null;this.display_initials=true;const a=function(t){const n=["element","max_team_images","team_image_size","item","supported_itemtypes","allow_add_item","allow_add_column","dark_theme","background_refresh_interval","column_field","allow_modify_view","limit_addcard_columns","allow_order_card","allow_create_column","allow_delete_item","supported_filters","display_initials"];e.dark_theme=$("html").css("--is-dark").trim()==="true";if(t.length===1){for(let a=0;a<n.length;a++){const o=n[a];if(t[0][o]!==undefined){e[o]=t[0][o]}}}if(t[0]["rights"]!==undefined){e.rights=new GLPIKanbanRights(t[0]["rights"])}else{e.rights=new GLPIKanbanRights({create_item:e.allow_add_item,delete_item:e.allow_delete_item,create_column:e.allow_create_column,modify_view:e.allow_modify_view,create_card_limited_columns:e.limit_addcard_columns,order_card:e.allow_order_card})}if(e.filters._text===undefined){e.filters._text=""}e.filter_input=null};const o=function(){e.mutation_observer=new MutationObserver((t=>{t.forEach((t=>{if(t.addedNodes.length>0){if(e.is_sorting_active){const n=[...t.addedNodes].filter((e=>e.classList.contains("sortable-placeholder")));if(n.length>0){const t=$(n[0]);const a=t.closest(".kanban-column").attr("id");const o=$("#"+a+' ul.kanban-body > li:not([id="'+e.sort_data.card_id+'"])');const i=o.index(t.get(0));const s=$("#"+e.sort_data.card_id);s.data("current-pos",i);if(!e.rights.canOrderCard()){if(a===e.sort_data.source_column){if(i!==e.sort_data.source_position){t.addClass("invalid-position")}else{t.removeClass("invalid-position")}}else{if(!$(t).is(":last-child")){t.addClass("invalid-position")}else{t.removeClass("invalid-position")}}}}}}}))}));e.mutation_observer.observe($(e.element).get(0),{subtree:true,childList:true})};const i=function(){$(e.element).trigger("kanban:pre_build");o();if(e.show_toolbar){s()}const t=$("<div class='kanban-container'><div class='kanban-columns'></div></div>").appendTo($(e.element));let n="<ul id='kanban-add-dropdown' class='kanban-dropdown dropdown-menu' style='display: none'>";Object.keys(e.supported_itemtypes).forEach((function(t){if(e.supported_itemtypes[t]["allow_create"]!==false){n+="<li id='kanban-add-"+t+"' class='dropdown-item'><span>"+e.supported_itemtypes[t]["name"]+"</span></li>"}}));n+="</ul>";t.append(n);let a="<ul id='kanban-overflow-dropdown' class='kanban-dropdown  dropdown-menu' style='display: none'>";let i="<ul id='kanban-bulk-add-dropdown' class='dropdown-menu' style='display: none'>";Object.keys(e.supported_itemtypes).forEach((function(t){if(e.supported_itemtypes[t]["allow_create"]!==false){i+="<li id='kanban-bulk-add-"+t+"' class='dropdown-item'><span>"+e.supported_itemtypes[t]["name"]+"</span></li>"}}));i+="</ul>";const l='<a href="#">'+'<i class="fa-fw fas fa-list"></i>'+__("Bulk add")+"</a>";a+='<li class="dropdown-trigger dropdown-item">'+l+i+"</li>";if(e.rights.canModifyView()){a+="<li class='kanban-remove dropdown-item' data-forbid-protected='true'><span>"+'<i class="fa-fw ti ti-trash"></i>'+__("Delete")+"</span></li>"}a+="</ul>";t.append(a);let r="<ul id='kanban-item-overflow-dropdown' class='kanban-dropdown dropdown-menu' style='display: none'>";r+=`\n            <li class='kanban-item-goto dropdown-item'>\n               <a href="#"><i class="fa-fw fas fa-share"></i>${__("Go to")}</a>\n            </li>`;if(e.rights.canDeleteItem()){r+=`\n                <li class='kanban-item-remove dropdown-item'>\n                   <span>\n                      <i class="fa-fw ti ti-trash"></i>${__("Delete")}\n                   </span>\n                </li>`}r+="</ul>";t.append(r);$("#kanban-overflow-dropdown li.dropdown-trigger > a").on("click",(function(e){$(this).parent().toggleClass("active");$(this).parent().find("ul").toggle();e.stopPropagation();e.preventDefault()}));$("#kanban-item-overflow-dropdown li.dropdown-trigger > a").on("click",(function(e){$(this).parent().toggleClass("active");$(this).parent().find("ul").toggle();e.stopPropagation();e.preventDefault()}));const c=function(){if(Object.keys(e.user_state.state).length===0){q(true,true)}};e.refresh(c,null,null,true);if(e.rights.canModifyView()){A();if(e.rights.canCreateColumn()){F()}}$(e.element).trigger("kanban:post_build")};const s=function(){$(e.element).trigger("kanban:pre_build_toolbar");let t=$("<div class='kanban-toolbar card flex-column flex-md-row'></div>").appendTo(e.element);$("<select name='kanban-board-switcher'></select>").appendTo(t);let n=$(`<input name='filter' class='form-control ms-1' type='text' placeholder="${__("Search or filter results")}" autocomplete="off"/>`).appendTo(t);if(e.rights.canModifyView()){let e="<button class='kanban-add-column btn btn-outline-secondary ms-1'>"+__("Add column")+"</button>";t.append(e)}e.filter_input=new SearchInput(n,{allowed_tags:e.supported_filters,on_result_change:(t,n)=>{e.filters={_text:""};e.filters._text=n.getFullPhrase();n.getTaggedTerms().forEach((t=>e.filters[t.tag]={term:t.term||"",exclusion:t.exclusion||false,prefix:t.prefix}));e.filter()},tokenizer_options:{custom_prefixes:{"#":{label:__("Regex"),token_color:"#00800080"}}}});e.refreshSearchTokenizer();e.filter();$(e.element).trigger("kanban:post_build_toolbar")};const l=function(t){return"#column-"+e.column_field.id+"-"+t};const r=function(e){let t=[e];if(typeof e!=="string"){t=$(e).prop("id").split("-")}else{t=e.split("-")}return t[t.length-1]};const c=function(){e.temp_forms={};let t=$(e.element+" .kanban-column");$.each(t,(function(t,n){let a=$(n).find(".kanban-add-form");if(a.length>0){e.temp_forms[n.id]=[];$.each(a,(function(t,a){e.temp_forms[n.id].push($(a).clone(true,true))}))}}))};const d=function(){if(e.temp_forms!==undefined&&Object.keys(e.temp_forms).length>0){$.each(e.temp_forms,(function(e,t){let n=$("#"+e);if(n.length>0){let e=n.find(".kanban-body").first();$.each(t,(function(t,n){$(n).appendTo(e)}))}}));e.temp_forms={}}};const m=function(){e.temp_kanban_scroll={left:$(e.element+" .kanban-container").scrollLeft(),top:$(e.element+" .kanban-container").scrollTop()};e.temp_column_scrolls={};let t=$(e.element+" .kanban-column");$.each(t,(function(t,n){let a=$(n).find(".kanban-body");if(a.scrollTop()!==0){e.temp_column_scrolls[n.id]=a.scrollTop()}}))};const u=function(){if(e.temp_kanban_scroll!==null){$(e.element+" .kanban-container").scrollLeft(e.temp_kanban_scroll.left);$(e.element+" .kanban-container").scrollTop(e.temp_kanban_scroll.top)}if(e.temp_column_scrolls!==null){$.each(e.temp_column_scrolls,(function(e,t){$("#"+e+" .kanban-body").scrollTop(t)}))}e.temp_kanban_scroll={};e.temp_column_scrolls={}};const f=function(){m();c();$(e.element+" .kanban-column").remove()};const p=function(t){if(t===undefined){t=$(e.element+" .kanban-container .kanban-columns").first()}let n=[];$.each(e.user_state.state,(function(a,o){if(o["visible"]!==false&&o!=="false"){if(e.columns[o["column"]]!==undefined){G(o["column"],e.columns[o["column"]],t)}}n.push(o["column"])}));$.each(e.columns,(function(e,a){if(!n.includes(e)){if(a["id"]===undefined){G(e,a,t)}}}));d();u()};const _=function(){const t=$("#kanban-add-dropdown");const n=$("#kanban-overflow-dropdown");const a=$("#kanban-item-overflow-dropdown");g();if(Object.keys(e.supported_itemtypes).length>0){$(e.element+" .kanban-container").on("click",".kanban-add",(function(e){const n=$(e.target);const a=$(t.data("trigger-button")).prop("id")!==n.prop("id");t.css({position:"fixed",left:n.offset().left,top:n.offset().top+n.outerHeight(true),display:t.css("display")==="none"||a?"inline":"none"});t.data("trigger-button",n)}))}$(window).on("click",(function(n){if(!$(n.target).hasClass("kanban-add")){t.css({display:"none"})}if(e.rights.canModifyView()){if(!$.contains($(e.add_column_form)[0],n.target)){$(e.add_column_form).css({display:"none"})}if(e.rights.canCreateColumn()){if(!$.contains($(e.create_column_form)[0],n.target)&&!$.contains($(e.add_column_form)[0],n.target)){$(e.create_column_form).css({display:"none"})}}}}));if(Object.keys(e.supported_itemtypes).length>0){$(e.element+" .kanban-container").on("click",".kanban-column-overflow-actions",(function(e){const t=$(e.target);const a=$(n.data("trigger-button")).prop("id")!==t.prop("id");n.css({position:"fixed",left:t.offset().left,top:t.offset().top+t.outerHeight(true),display:n.css("display")==="none"||a?"inline":"none"});n.find("ul").css({display:"none"});n.find("li").removeClass("active");const o=$(e.target.closest(".kanban-column"));if(o.hasClass("kanban-protected")){n.find('li[data-forbid-protected="true"]').hide()}else{n.find('li[data-forbid-protected="true"]').show()}n.data("trigger-button",t)}))}$(e.element+" .kanban-container").on("click",".kanban-item-overflow-actions",(function(e){const t=$(e.target);const n=$(a.data("trigger-button")).prop("id")!==t.prop("id");a.css({position:"fixed",left:t.offset().left,top:t.offset().top+t.outerHeight(true),display:a.css("display")==="none"||n?"inline":"none"});a.find("ul").css({display:"none"});a.find("li").removeClass("active");a.data("trigger-button",t);const o=$(t.closest(".kanban-item"));const i=o.data("form_link");$(a.find(".kanban-item-goto a")).attr("href",i);let s=$(a.find(".kanban-item-remove"));if(o.hasClass("deleted")){s.html('<span><i class="ti ti-trash"></i>'+__("Purge")+"</span>")}else{s.html('<span><i class="ti ti-trash"></i>'+__("Delete")+"</span>")}}));$(window).on("click",(function(t){if(!$(t.target).hasClass("kanban-column-overflow-actions")){n.css({display:"none"})}if(!$(t.target).hasClass("kanban-item-overflow-actions")){a.css({display:"none"})}if(e.rights.canModifyView()){if(!$.contains($(e.add_column_form)[0],t.target)){$(e.add_column_form).css({display:"none"})}if(e.rights.canCreateColumn()){if(!$.contains($(e.create_column_form)[0],t.target)&&!$.contains($(e.add_column_form)[0],t.target)){$(e.create_column_form).css({display:"none"})}}}}));$(e.element+" .kanban-container").on("click",".kanban-remove",(function(e){const t=$(e.target.closest(".kanban-dropdown")).data("trigger-button").closest(".kanban-column");C(r(t))}));$(e.element).on("click",".item-details-panel .kanban-item-edit-team",(t=>{e.showTeamModal($(t.target).closest(".item-details-panel").data("card"))}));$(e.element+" .kanban-container").on("click",".kanban-item-remove",(function(e){const t=$(e.target.closest(".kanban-dropdown")).data("trigger-button").closest(".kanban-item").prop("id");v(t,undefined,undefined)}));$(e.element+" .kanban-container").on("click",".kanban-collapse-column",(function(t){e.toggleCollapseColumn(t.target.closest(".kanban-column"))}));$(e.element).on("click",".kanban-add-column",(function(){k()}));$(e.add_column_form).on("input","input[name='column-name-filter']",(function(){const t=$(this);$(e.add_column_form+" li").hide();$(e.add_column_form+" li").filter((function(){return $(this).text().toLowerCase().includes(t.val().toLowerCase())})).show()}));$(e.add_column_form).on("change","input[type='checkbox']",(function(){const e=$(this).parent().data("list-id");if(e!==undefined){if($(this).is(":checked")){x(e)}else{C(e)}}}));$(e.add_column_form).on("submit","form",(function(e){e.preventDefault()}));$(e.add_column_form).on("click",".kanban-create-column",(function(){const t=$(e.element+" .kanban-toolbar");$(e.add_column_form).css({display:"none"});$(e.create_column_form).css({display:"block",position:"fixed",left:t.offset().left+t.outerWidth(true)-$(e.create_column_form).outerWidth(true),top:t.offset().top+t.outerHeight(true)})}));$(e.create_column_form).on("submit","form",(function(t){t.preventDefault();const n=$(e.element+" .kanban-toolbar");$(e.create_column_form).css({display:"none"});const a=$(e.create_column_form+" input[name='name']").val();$(e.create_column_form+" input[name='name']").val("");const o=$(e.create_column_form+" input[name='color']").val();V(a,{color:o},(function(){k();$(e.add_column_form).css({display:"block",position:"fixed",left:n.offset().left+n.outerWidth(true)-$(e.add_column_form).outerWidth(true),top:n.offset().top+n.outerHeight(true)})}))}));$("#kanban-add-dropdown li").on("click",(function(t){t.preventDefault();const n=$(this).closest("li");const a=n.parent();const o=$($(a.data("trigger-button")).closest(".kanban-column"));const i=n.prop("id").split("-")[2];e.clearAddItemForms(o);e.showAddItemForm(o,i);D()}));$("#kanban-bulk-add-dropdown li").on("click",(function(t){t.preventDefault();const n=$(this).closest("li");const a=n.closest(".kanban-dropdown");const o=$($(a.data("trigger-button")).closest(".kanban-column"));const i=n.prop("id").split("-")[3];a.css({display:"none"});e.clearAddItemForms(o);e.showBulkAddItemForm(o,i);D()}));const o=$("select[name='kanban-board-switcher']").first();$(e.element+" .kanban-toolbar").on("select2:select",o,(function(t){const n=t.params.data.id;$.ajax({type:"GET",url:e.ajax_root+"kanban.php",data:{action:"get_url",itemtype:e.item.itemtype,items_id:n},success:function(e){window.location=e}})}));$(e.element).on("input",".kanban-add-form input, .kanban-add-form textarea",(function(){D()}));if(!e.rights.canOrderCard()){$(e.element).on("mouseenter",".kanban-column",(function(){if(e.is_sorting_active){return}$(this).find(".kanban-body > li").removeClass("temporarily-readonly");$(this).siblings().find(".kanban-body > li").addClass("temporarily-readonly")}));$(e.element).on("mouseleave",".kanban-column",(function(){if(e.is_sorting_active){return}$(e.element).find(".kanban-body > li").removeClass("temporarily-readonly")}))}$(e.element+" .kanban-container").on("submit",".kanban-add-form:not(.kanban-bulk-add-form)",(function(t){t.preventDefault();const n=$(t.target);const a={inputs:n.serialize(),itemtype:n.prop("id").split("_")[2],action:"add_item"};const o=n.attr("data-itemtype");const i=n.closest(".kanban-column").attr("id");$.ajax({method:"POST",url:e.ajax_root+"kanban.php",data:a}).done((function(){n.remove();e.refresh(undefined,undefined,(()=>{e.showAddItemForm($(`#${i}`),o)}))}))}));$(e.element+" .kanban-container").on("click",".kanban-item .kanban-item-title",(function(t){t.preventDefault();const n=$(t.target).closest(".kanban-item");e.showCardPanel(n)}))};const b=(e,t)=>{const n=$("#kanban-modal");n.removeData();n.data(t);n.find(".modal-body").html(e);n.modal("show")};const h=()=>{$("#kanban-modal").modal("hide")};const k=function(){let t=[];$(e.element+" .kanban-columns .kanban-column").each((function(){const e=this.id.split("-");t.push(e[e.length-1])}));const n=$(e.add_column_form);const a=$(e.element+" .kanban-toolbar");$.ajax({method:"GET",url:e.ajax_root+"kanban.php",data:{action:"list_columns",itemtype:e.item.itemtype,column_field:e.column_field.id}}).done((function(o){const i=$(e.add_column_form+" .kanban-item-content");i.empty();i.append("<input type='text' class='form-control' name='column-name-filter' placeholder='"+__("Search")+"'/>");let s="<ul class='kanban-columns-list'>";$.each(o,(function(e,n){let a="<li data-list-id='"+e+"'>";if(t.includes(e)){a+="<input type='checkbox' checked='true' class='form-check-input' />"}else{a+="<input type='checkbox' class='form-check-input' />"}if(typeof n["color_class"]!=="undefined"){a+="<span class='kanban-color-preview "+n["color_class"]+"'></span>"}else{a+="<span class='kanban-color-preview' style='background-color: "+n["header_color"]+"'></span>"}a+=n["name"]+"</li>";s+=a}));s+="</ul>";i.append(s);i.append();n.css({display:"block",position:"fixed",left:a.offset().left+a.outerWidth(true)-n.outerWidth(true),top:a.offset().top+a.outerHeight(true)})}))};const g=function(){$(e.element).trigger("kanban:refresh_sortables");const t=$(e.element+" .kanban-body");$.each(t,(function(e){const t=$(e);if(t.data("sortable")){sortable(e,"destroy")}}));sortable(e.element+" .kanban-body",{acceptFrom:".kanban-body",items:".kanban-item:not(.readonly):not(.temporarily-readonly)"});$(e.element+" .kanban-body").off("sortstart");$(e.element+" .kanban-body").on("sortstart",(t=>{e.is_sorting_active=true;const n=$(t.detail.item);const a=n.closest(".kanban-column").attr("id");n.data("source-col",a);n.data("source-pos",t.detail.origin.index);e.sort_data={card_id:n.attr("id"),source_column:a,source_position:t.detail.origin.index}}));$(e.element+" .kanban-body").off("sortupdate");$(e.element+" .kanban-body").on("sortupdate",(function(t){const n=t.detail.item;if(this===$(n).parent()[0]){return e.onKanbanCardSort(t,this)}}));$(e.element+" .kanban-body").off("sortstop");$(e.element+" .kanban-body").on("sortstop",(t=>{e.is_sorting_active=false;$(t.detail.item).closest(".kanban-column").trigger("mouseenter")}));if(e.rights.canModifyView()){sortable(e.element+" .kanban-columns",{acceptFrom:e.element+" .kanban-columns",appendTo:".kanban-container",items:".kanban-column:not(.kanban-protected)",handle:".kanban-column-header",orientation:"horizontal"});$(e.element+" .kanban-columns .kanban-column:not(.kanban-protected) .kanban-column-header").addClass("grab")}$(e.element+" .kanban-columns").off("sortstop");$(e.element+" .kanban-columns").on("sortstop",(e=>{const t=e.detail.item;j(r(t),$(t).index())}))};const y=function(t){let n="<span class='kanban-column-toolbar'>";const a=parseInt(r(t["id"]));if(e.rights.canCreateItem()&&(e.rights.getAllowedColumnsForNewCards().length===0||e.rights.getAllowedColumnsForNewCards().includes(a))){n+="<i id='kanban_add_"+t["id"]+"' class='kanban-add btn btn-sm btn-ghost-secondary fas fa-plus' title='"+__("Add")+"'></i>";n+="<i id='kanban_column_overflow_actions_"+t["id"]+"' class='kanban-column-overflow-actions btn btn-sm btn-ghost-secondary fas fa-ellipsis-h' title='"+__("More")+"'></i>"}n+="</span>";return n};this.hideEmpty=function(){const e=$(".kanban-body");e.each((function(e,t){if(t.childElementCount===0){t.parentElement.style.display="none"}}))};this.showEmpty=function(){const e=$(".kanban-column");e.each((function(e,t){t.style.display="block"}))};this.onKanbanCardSort=function(t,n){const a=n.parentElement;const o=$(t.detail.origin.container);const i=$(t.detail.item);const s=i.attr("id").split("-");const l=$(a).attr("id").split("-");const r=l[l.length-1];if(s.length===2&&o!==null&&!(!e.rights.canOrderCard()&&o.length===0)){$.ajax({type:"POST",url:e.ajax_root+"kanban.php",data:{action:"update",itemtype:s[0],items_id:s[1],column_field:e.column_field.id,column_value:r},error:function(){window.sortable(n,"cancel");return false},success:function(){let t=i.data("current-pos");if(!e.rights.canOrderCard()){i.appendTo($(a).find(".kanban-body").first());t=i.index()}e.updateColumnCount($(o).closest(".kanban-column"));e.updateColumnCount($(a).closest(".kanban-column"));i.removeData("source-col");w(i.attr("id"),a.id,t);return true}})}else{window.sortable(n,"cancel");return false}};const w=function(t,n,a,o,i){if(typeof n==="string"&&n.lastIndexOf("column",0)===0){n=r(n)}$.ajax({type:"POST",url:e.ajax_root+"kanban.php",data:{action:"move_item",card:t,column:n,position:a,kanban:e.item},error:function(){if(o){o()}},success:function(){if(i){i();$("#"+t).trigger("kanban:card_move")}}})};const v=function(t,n,a){const[o,i]=t.split("-",2);const s=$("#"+t);const l=s.hasClass("deleted");$.ajax({type:"POST",url:e.ajax_root+"kanban.php",data:{action:"delete_item",itemtype:o,items_id:i,force:l?1:0},error:function(){if(n){n()}},success:function(){const n=s.closest(".kanban-column");s.remove();e.updateColumnCount(n);if(a){a();$("#"+t).trigger("kanban:card_delete")}}})};const x=function(t){$.ajax({type:"POST",url:e.ajax_root+"kanban.php",data:{action:"show_column",column:t,kanban:e.item},complete:function(){$.each(e.user_state.state,(function(n,a){if(parseInt(a["column"])===parseInt(t)){e.user_state.state[n]["visible"]=true;return false}}));N(t,false,true);$(e.element+" .kanban-add-column-form li[data-list-id='"+t+"']").prop("checked",true)}})};const C=function(t){$.ajax({type:"POST",url:e.ajax_root+"kanban.php",data:{action:"hide_column",column:t,kanban:e.item},complete:function(){$(l(t)).remove();$.each(e.user_state.state,(function(n,a){if(parseInt(a["column"])===parseInt(t)){e.user_state.state[n]["visible"]=false;return false}}));$(e.element+" .kanban-add-column-form li[data-list-id='"+t+"']").prop("checked",false)}})};const j=function(t,n){$.ajax({type:"POST",url:e.ajax_root+"kanban.php",data:{action:"move_column",column:t,position:n,kanban:e.item}})};const T=function(t){const n=t["itemtype"];const a=t["id"];if(e.team_badge_cache[n]===undefined||e.team_badge_cache[n][a]===undefined){if(n==="User"){let o=null;$.ajax({url:e.ajax_root+"getUserPicture.php",async:false,data:{users_id:[a],size:e.team_image_size}}).done((function(e){if(e[a]!==undefined){o=e[a]}else{o=null}}));if(o){e.team_badge_cache[n][a]="<span>"+o+"</span>"}else{e.team_badge_cache[n][a]=z(t)}}else{switch(n){case"Group":e.team_badge_cache[n][a]=P(t,"fa-users");break;case"Supplier":e.team_badge_cache[n][a]=P(t,"fa-briefcase");break;case"Contact":e.team_badge_cache[n][a]=P(t,"fa-user");break;default:e.team_badge_cache[n][a]=P(t,"fa-user")}}}return e.team_badge_cache[n][a]};const S=function(t){let n=[];$.each(e.columns,(function(t,a){if(a["items"]!==undefined){$.each(a["items"],(function(t,a){if(a["_team"]!==undefined){Object.values(a["_team"]).slice(0,e.max_team_images).forEach((function(t){if(t["itemtype"]==="User"){if(e.team_badge_cache["User"][t["id"]]===undefined){n[t["id"]]=t}}}))}}))}}));if(n.length===0){return}$.ajax({url:e.ajax_root+"getUserPicture.php",async:false,data:{users_id:Object.keys(n),size:e.team_image_size}}).done((function(a){Object.keys(n).forEach((function(t){const o=n[t];if(a[t]!==undefined){e.team_badge_cache["User"][t]="<span>"+a[t]+"</span>"}else{e.team_badge_cache["User"][t]=z(o)}}));if(t!==undefined&&t["trim_cache"]!==undefined){let t=JSON.parse(window.sessionStorage.getItem("badge_colors"));Object.keys(e.team_badge_cache["User"]).forEach((function(a){if(n[a]===undefined){delete e.team_badge_cache["User"][a];delete t["User"][a]}}));window.sessionStorage.setItem("badge_colors",JSON.stringify(t))}}))};const O=function(e,t,n){let a,o,i;if(t===0){a=o=i=n}else{const s=function e(t,n,a){if(a<0)a+=1;if(a>1)a-=1;if(a<1/6)return t+(n-t)*6*a;if(a<1/2)return n;if(a<2/3)return t+(n-t)*(2/3-a)*6;return t};const l=n<.5?n*(1+t):n+t-n*t;const r=2*n-l;a=s(r,l,e+1/3);o=s(r,l,e);i=s(r,l,e-1/3)}a=("0"+(a*255).toString(16)).substr(-2);o=("0"+(o*255).toString(16)).substr(-2);i=("0"+(i*255).toString(16)).substr(-2);return"#"+a+o+i};const I=function(t){let n=JSON.parse(window.sessionStorage.getItem("badge_colors"));const a=t["itemtype"];const o=Math.random();const i=Math.random()*10+(e.dark_theme?25:70);let s=O(o,1,i/100);if(n!==null&&n[a]!==null&&n[a][t["id"]]){s=n[a][t["id"]]}else{if(n===null){n={User:{},Group:{},Supplier:{},Contact:{},_dark_theme:e.dark_theme}}n[a][t["id"]]=s;window.sessionStorage.setItem("badge_colors",JSON.stringify(n))}return s};const z=function(t){let n="";if(t["firstname"]){n+=t["firstname"][0]}if(t["realname"]){n+=t["realname"][0]}n=n.toUpperCase();if(!e.display_initials||n.length===0){return P(t,"fa-user")}const a=document.createElement("canvas");a.width=e.team_image_size;a.height=e.team_image_size;const o=a.getContext("2d");o.strokeStyle="#f1f1f1";o.fillStyle=I(t);o.beginPath();o.arc(e.team_image_size/2,e.team_image_size/2,e.team_image_size/2,0,2*Math.PI);o.fill();o.fillStyle=e.dark_theme?"white":"black";o.textAlign="center";o.font="bold "+e.team_image_size/2+"px sans-serif";o.textBaseline="middle";o.fillText(n,e.team_image_size/2,e.team_image_size/2);const i=a.toDataURL("image/png");const s=t["name"].replace(/"/g,"&quot;").replace(/'/g,"&#39;");return"<span><img src='"+i+"' title='"+s+"'/></span>"};const P=function(t,n){const a=I(t);const o=t["name"].replace(/"/g,"&quot;").replace(/'/g,"&#39;");return`\n            <span class='fa-stack fa-lg' style='font-size: ${e.team_image_size/2}px'>\n                <i class='fas fa-circle fa-stack-2x' style="color: ${a}" title="${t["name"]}"></i>\n                <i class='fas ${n} fa-stack-1x' title="${o}"></i>\n            </span>\n         `};const M=function(t){const n=document.createElement("canvas");n.width=e.team_image_size;n.height=e.team_image_size;const a=n.getContext("2d");a.strokeStyle="#f1f1f1";const o=e.dark_theme?40:80;a.fillStyle="hsl(255, 0%,"+o+"%,1)";a.beginPath();a.arc(e.team_image_size/2,e.team_image_size/2,e.team_image_size/2,0,2*Math.PI);a.fill();a.fillStyle=e.dark_theme?"white":"black";a.textAlign="center";a.font="bold "+e.team_image_size/2+"px sans-serif";a.textBaseline="middle";a.fillText("+"+t,e.team_image_size/2,e.team_image_size/2);const i=n.toDataURL("image/png");return"<span><img src='"+i+"' title='"+__("%d other team members").replace("%d",t)+"'/></span>"};const L=function(e){const t=e.startsWith("#")?e.substring(1):e;const n=parseInt(t,16);const a=n>>16&255;const o=n>>8&255;const i=n>>0&255;const s=.2126*a+.7152*o+.0722*i;return s>110};const E=function(e){const t=/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+\.?\d*))?\)$/;const n=e.match(t).slice(1).map(((e,t)=>(t===3?Math.round(parseFloat(e)*255):parseFloat(e)).toString(16).padStart(2,"0").replace("NaN",""))).join("");return`#${n}`};this.updateColumnCount=function(e){if(!(e instanceof jQuery)){e=$(e)}const t=$(e).find(".kanban-body:first");const n=$(e).find(".kanban_nb:first");const a=t.find("li:not(.filtered-out)");n.text(a.length)};this.clearAddItemForms=function(e){if(!(e instanceof jQuery)){e=$(e)}e.find("form").remove()};this.showAddItemForm=function(t,n){if(!(t instanceof jQuery)){t=$(t)}const a=Math.floor(Math.random()*999999);const o="form_add_"+n+"_"+a;let i=`<form id="${o}" class="kanban-add-form card kanban-form no-track" data-itemtype="${n}">`;let s="<div class='kanban-item-header d-flex justify-content-between'>";s+=`\n            <span class='kanban-item-title'>\n               <i class="${e.supported_itemtypes[n]["icon"]}"></i>\n               ${e.supported_itemtypes[n]["name"]}\n            </span>`;s+=`<i class="ti ti-x cursor-pointer" title="${__("Close")}" onclick="$(this).parent().parent().remove()"></i></div>`;i+=s;i+="<div class='kanban-item-content'>";$.each(e.supported_itemtypes[n]["fields"],(function(e,t){const n=t["type"]!==undefined?t["type"]:"text";const a=t["value"]!==undefined?t["value"]:"";if(n.toLowerCase()==="textarea"){i+="<textarea class='form-control' name='"+e+"'";if(t["placeholder"]!==undefined){i+=" placeholder='"+t["placeholder"]+"'"}if(a!==undefined){i+=" value='"+a+"'"}i+="></textarea>"}else if(n.toLowerCase()==="raw"){i+=a}else{i+="<input class='form-control' type='"+n+"' name='"+e+"'";if(t["placeholder"]!==undefined){i+=" placeholder='"+t["placeholder"]+"'"}if(a!==undefined){i+=" value='"+a+"'"}i+="/>"}}));i+="</div>";const l=t.prop("id").split("-");const r=l[l.length-1];i+="<input type='hidden' name='"+e.column_field.id+"' value='"+r+"'/>";i+="<input type='submit' value='"+__("Add")+"' name='add' class='btn btn-primary'/>";i+="</form>";$(t.find(".kanban-body")[0]).append(i);$("#"+o).get(0).scrollIntoView(false)};this.showBulkAddItemForm=function(t,n){if(!(t instanceof jQuery)){t=$(t)}const a=Math.floor(Math.random()*999999);const o="form_add_"+n+"_"+a;let i="<form id='"+o+"' class='kanban-add-form kanban-bulk-add-form kanban-form no-track'>";i+=`\n            <div class='kanban-item-header'>\n                <span class='kanban-item-title'>\n                   <i class="${e.supported_itemtypes[n]["icon"]}"></i>\n                   ${e.supported_itemtypes[n]["name"]}\n                </span>\n                <i class='ti ti-x' title='Close' onclick='$(this).parent().parent().remove()'></i>\n                <div>\n                    <span class="kanban-item-subtitle">${__("One item per line")}</span>\n                 </div>\n           </div>\n         `;i+="<div class='kanban-item-content'>";$.each(e.supported_itemtypes[n]["fields"],(function(e,t){const n=t["type"]!==undefined?t["type"]:"text";const a=t["value"]!==undefined?t["value"]:"";if(n==="hidden"){i+="<input type='hidden' name='"+e+"'";if(a!==undefined){i+=" value='"+a+"'"}i+="/>"}else if(n.toLowerCase()==="raw"){i+=a}}));i+="<textarea name='bulk_item_list'></textarea>";i+="</div>";const s=t.prop("id").split("-");const l=s[s.length-1];i+="<input type='hidden' name='"+e.column_field.id+"' value='"+l+"'/>";i+="<input type='submit' value='"+__("Add")+"' name='add' class='submit'/>";i+="</form>";$(t.find(".kanban-body")[0]).append(i);$("#"+o).get(0).scrollIntoView(false);$("#"+o).on("submit",(function(t){t.preventDefault();const n=$(t.target);const a={inputs:n.serialize(),itemtype:n.prop("id").split("_")[2],action:"bulk_add_item"};$.ajax({method:"POST",url:e.ajax_root+"kanban.php",data:a}).done((function(){$("#"+o).remove();e.refresh()}))}))};const A=function(){const t=Math.floor(Math.random()*999999);const n="form_add_column_"+t;e.add_column_form="#"+n;let a=`\n            <div id="${n}" class="kanban-form kanban-add-column-form dropdown-menu" style="display: none">\n                <form class='no-track'>\n                    <div class='kanban-item-header'>\n                        <span class='kanban-item-title'>${__("Add a column from existing status")}</span>\n                    </div>\n                    <div class='kanban-item-content'></div>\n         `;if(e.rights.canCreateColumn()){a+=`\n               <hr>${__("Or add a new status")}\n               <button class='btn btn-primary kanban-create-column d-block'>${__("Create status")}</button>\n            `}a+="</form></div>";$(e.element).prepend(a)};const F=function(){const t=Math.floor(Math.random()*999999);const n="form_create_column_"+t;e.create_column_form="#"+n;let a=`\n            <div id='${n}' class='kanban-form kanban-create-column-form dropdown-menu' style='display: none'>\n                <form class='no-track'>\n                    <div class='kanban-item-header'>\n                        <span class='kanban-item-title'>${__("Create status")}</span>\n                    </div>\n                    <div class='kanban-item-content'>\n                    <input name='name' class='form-control'/>\n         `;$.each(e.column_field.extra_fields,(function(e,t){if(e===undefined){return true}let n=t.value!==undefined?t.value:"";if(t.type===undefined||t.type==="text"){a+="<input name='"+e+"' value='"+n+"'/>"}else if(t.type==="color"){if(n.length===0){n="#000000"}a+="<input type='color' name='"+e+"' value='"+n+"'/>"}}));a+="</div>";a+="<button type='submit' class='btn btn-primary'>"+__("Create status")+"</button>";a+="</form></div>";$(e.element).prepend(a)};const D=function(){window.clearTimeout(n);n=window.setTimeout(t,1e4)};this.refresh=function(t,n,a,o){const i=function(){$.ajax({method:"GET",url:e.ajax_root+"kanban.php",data:{action:"refresh",itemtype:e.item.itemtype,items_id:e.item.items_id,column_field:e.column_field.id}}).done((function(n,a,o){S({trim_cache:true});f();e.columns=n;p();e.filter();if(t){t(n,a,o);$(e.element).trigger("kanban:refresh")}})).fail((function(e,t,a){if(n){n(e,t,a)}})).always((function(){if(a){a()}}))};if(o===undefined||o===true){i()}else{q(false,false,null,null,(function(){H(i)}))}};const G=function(t,n,a,o){if(a==null){a=$(e.element+" .kanban-container .kanban-columns").first()}o=o!==undefined?o:false;n["id"]="column-"+e.column_field.id+"-"+t;let i="";let s=-1;$.each(e.user_state.state,(function(e,n){if(parseInt(n["column"])===parseInt(t)){s=e;if(n["folded"]===true||n["folded"]==="true"){i="collapsed";return false}}}));const l=n["_protected"]?"kanban-protected":"";const r="kanban-column card "+i+" "+l;const c=typeof n["header_color"]!=="undefined"?n["header_color"]:"";const d="<div id='"+n["id"]+"' style='border-top-color: "+c+"' class='"+r+"'></div>";let m=null;if(s<0){m=$(d).appendTo(a)}else{const e=$(a).find(".kanban-column:nth-child("+s+")");if(e.length===1){m=$(d).insertAfter(e)}else{m=$(d).appendTo(a)}}const u=n["items"]!==undefined?n["items"]:[];const f=$("<header class='kanban-column-header'></header>");const p=$("<div class='kanban-column-header-content'></div>").appendTo(f);const _=n["items"]!==undefined?n["items"].length:0;const b=$("<span class=''></span>").appendTo(p);const h=$("<span class=''></span>").appendTo(p);if(e.rights.canModifyView()){$(b).append("<i class='fas fa-caret-right fa-lg kanban-collapse-column btn btn-sm btn-ghost-secondary' title='"+__("Toggle collapse")+"'/>")}$(b).append("<span class='kanban-column-title badge "+(n["color_class"]||"")+"' style='background-color: "+n["header_color"]+"; color: "+n["header_fg_color"]+";'>"+n["name"]+"</span></span>");$(h).append("<span class='kanban_nb badge bg-secondary'>"+_+"</span>");$(h).append(y(n));$(m).prepend(f);const k=$("#"+n["id"]).find(".kanban-column-title").eq(0);let w=k.css("background-color")?E(k.css("background-color")):"#ffffff";const v=w?L(w):!e.dark_theme;const x=v?"kanban-text-dark":"kanban-text-light";k.removeClass("kanban-text-light kanban-text-dark");k.addClass(x);const C=$("<ul class='kanban-body card-body'></ul>").appendTo(m);m.attr("data-drop-only",n["drop_only"]);if(!n["drop_only"]){let n=[];$.each(e.user_state.state,(function(e,a){if(a["column"]===t){$.each(a["cards"],(function(e,t){$.each(u,(function(e,a){if(a["id"]===t){U(m,a);n.push(a["id"]);return false}}))}))}}));$.each(u,(function(e,t){if(n.indexOf(t["id"])<0){U(m,t,o)}}))}else{$(`\n               <li class="position-relative mx-auto mt-2" style="width: 250px">\n                  ${__("This column cannot support showing cards due to how many cards would be shown. You can still drag cards into this column.")}\n               </li>\n            `).appendTo(C)}g()};const U=function(t,n,a=false){if(a){const t=$("#"+n["id"]);if(t!==undefined){const n=t.closest(".kanban-column");t.remove();e.updateColumnCount(n)}}const o=n["id"].split("-")[0];const i=$(t).find(".kanban-body").first();const s=n["_readonly"]!==undefined&&(n["_readonly"]===true||n["_readonly"]===1);let l=`\n            <li id="${n["id"]}" class="kanban-item card ${s?"readonly":""} ${n["is_deleted"]?"deleted":""}">\n                <div class="kanban-item-header">\n                    <span class="kanban-item-title" title="${n["title_tooltip"]}">\n                    <i class="${e.supported_itemtypes[o]["icon"]}"></i>\n                        ${n["title"]}\n                    </span>\n                    <i class="kanban-item-overflow-actions fas fa-ellipsis-h btn btn-sm btn-ghost-secondary"></i>\n                </div>\n                <div class="kanban-item-content">${n["content"]||""}</div>\n                <div class="kanban-item-team">\n         `;const r=Object.keys(n["_team"]).length;if(n["_team"]!==undefined&&r>0){$.each(Object.values(n["_team"]).slice(0,e.max_team_images),(function(e,t){l+=T(t)}));if(n["_team"].length>e.max_team_images){l+=M(r-e.max_team_images)}}l+="</div></li>";const c=$(l).appendTo(i);c.data("form_link",n["_form_link"]||undefined);if(n["_metadata"]){$.each(n["_metadata"],((e,t)=>{c.data(e,t)}))}c.data("_team",n["_team"]);e.updateColumnCount(t)};this.refreshSearchTokenizer=()=>{e.filter_input.tokenizer.clearAutocomplete();e.filter_input.tokenizer.setAutocomplete("type",Object.keys(e.supported_itemtypes).map((t=>`<i class="${e.supported_itemtypes[t].icon} me-1"></i>`+t)));e.filter_input.tokenizer.setAutocomplete("milestone",["true","false"]);$(e.element).trigger("kanban:refresh_tokenizer",e.filter_input.tokenizer)};this.clearFiltered=function(){$(e.element+" .kanban-item").each((function(e,t){$(t).removeClass("filtered-out")}))};this.filter=function(){$(e.element).trigger("kanban:pre_filter",e.filters);e.clearFiltered();$(e.element+" .kanban-item").each((function(t,n){const a=$(n);let o=true;const i=a.find("span.kanban-item-title").text().trim();const s=(e,t,n=["regex","includes"])=>{if(e.prefix==="#"&&n.includes("regex")){return c(e,t)}else{if(n.includes("includes")){l(e,t)}if(n.includes("equals")){r(e,t)}}};const l=(e,t)=>{if(!t.toLowerCase().includes(e.term.toLowerCase())!==e.exclusion){o=false}};const r=(e,t)=>{if(t!=e.term!==e.exclusion){o=false}};const c=(e,t)=>{try{if(!t.trim().match(e.term)!==e.exclusion){o=false}}catch(e){glpi_toast_error(__("The regular expression you entered is invalid. Please check it and try again."),__("Invalid regular expression"))}};const d=(e,t)=>{const n=a.data("_team");let i=false;$.each(n,((n,a)=>{if(a.itemtype===t&&a.name.toLowerCase().includes(e.term.toLowerCase())!==e.exclusion){i=true}}));if(!i){o=false}};if(e.filters._text){try{if(!i.match(new RegExp(e.filters._text,"i"))){o=false}}catch(t){if(!i.toLowerCase().includes(e.filters._text.toLowerCase())){o=false}}}if(e.filters.title!==undefined){s(e.filters.title,i)}if(e.filters.type!==undefined){s(e.filters.type,a.attr("id").split("-")[0],["regex","equals"])}if(e.filters.milestone!==undefined){e.filters.milestone.term=e.filters.milestone.term=="0"||e.filters.milestone.term=="false"?0:1;r(e.filters.milestone,a.data("is_milestone"))}if(e.filters.content!==undefined){s(e.filters.content,a.data("content"))}if(e.filters.team!==undefined){const t=e.filters.team.term.toLowerCase();const n=a.data("_team");let i=false;$.each(n,((e,n)=>{if(n.name.toLowerCase().includes(t)){i=true}}));if(!i){o=false}}if(e.filters.user!==undefined){d(e.filters.user,"User")}if(e.filters.group!==undefined){d(e.filters.group,"Group")}if(e.filters.supplier!==undefined){d(e.filters.supplier,"Supplier")}if(e.filters.contact!==undefined){d(e.filters.contact,"Contact")}if(!o){a.addClass("filtered-out")}}));$(e.element).trigger("kanban:filter",{filters:e.filters,kanban_element:e.element});$(e.element+" .kanban-column").each((function(t,n){e.updateColumnCount(n)}));$(e.element).trigger("kanban:post_filter",e.filters)};this.toggleCollapseColumn=function(t){if(!(t instanceof jQuery)){t=$(t)}t.toggleClass("collapsed");const n=t.hasClass("collapsed")?"collapse_column":"expand_column";$.ajax({type:"POST",url:e.ajax_root+"kanban.php",data:{action:n,column:r(t),kanban:e.item}})};const N=function(t,n,a,o=undefined){n=n!==undefined?n:false;let i=false;$.each(e.user_state.state,(function(e,n){if(parseInt(n["column"])===parseInt(t)){if(!n["visible"]){i=true}return false}}));if(i){if(o){o()}return}$.ajax({method:"GET",url:e.ajax_root+"kanban.php",async:false,data:{action:"get_column",itemtype:e.item.itemtype,items_id:e.item.items_id,column_field:e.column_field.id,column_id:t}}).done((function(n){if(n!==undefined&&Object.keys(n).length>0){e.columns[t]=n[t];G(t,e.columns[t],null,a)}})).always((function(){if(o){o()}}))};const V=function(t,n,a){if(t===undefined||t.length===0){if(a){a()}return}$.ajax({method:"POST",url:e.ajax_root+"kanban.php",data:{action:"create_column",itemtype:e.item.itemtype,items_id:e.item.items_id,column_field:e.column_field.id,column_name:t,params:n}}).always((function(){if(a){a()}}))};const R=function(){const t={is_dirty:true,state:{}};$(e.element+" .kanban-column").each((function(n,a){const o=$(a);const i=o.prop("id").split("-");const s=i[i.length-1];if(e.user_state.state[n]===undefined||s!==e.user_state.state[n]["column"]||e.user_state.state[n]["folded"]!==o.hasClass("collapsed")){t.is_dirty=true}t.state[n]={column:s,folded:o.hasClass("collapsed"),cards:{}};$.each(o.find(".kanban-item"),(function(a,o){t.state[n]["cards"][a]=$(o).prop("id");if(e.user_state.state[n]!==undefined&&e.user_state.state[n]["cards"]!==undefined&&e.user_state.state[n]["cards"][a]!==undefined&&e.user_state.state[n]["cards"][a]!==t.state[n]["cards"][a]){t.is_dirty=true}}))}));e.user_state=t};this.showCardPanel=t=>{if(!t){$(".item-details-panel").remove()}const[n,a]=t.prop("id").split("-");$.ajax({method:"GET",url:e.ajax_root+"kanban.php",data:{itemtype:n,items_id:a,action:"load_item_panel"}}).done((n=>{$(".item-details-panel").remove();$(e.element).append($(n));$(".item-details-panel").data("card",t);$(".item-details-panel ul.team-list li").each(((e,t)=>{t=$(t);const n=t.attr("data-itemtype");const a=t.attr("data-items_id");let o=T({itemtype:n,id:a,name:t.attr("data-name"),realname:t.attr("data-realname"),firstname:t.attr("data-firstname")});t.append(`\n                     <div class="member-details">\n                        ${o}\n                        ${escapeMarkupText(t.attr("data-name"))||`${n} (${a})`}\n                     </div>\n                     <button type="button" name="delete" class="btn btn-ghost-danger">\n                        <i class="ti ti-x" title="${__("Delete")}"></i>\n                     </button>\n                  `)}))}));$(e.element).on("click",'.item-details-panel ul.team-list button[name="delete"]',(e=>{const t=$(e.target).closest("li");const n=t.attr("data-itemtype");const a=t.attr("data-items_id");const o=$(e.target).closest(".item-details-panel");const i=o.attr("data-itemtype");const s=o.attr("data-items_id");const l=t.closest(".list-group").attr("data-role");if(i&&s){K(i,s,n,a,l);t.remove()}}))};this.showTeamModal=t=>{const[n,a]=t.prop("id").split("-",2);let o="";const i=$(`#kanban-teammember-item-dropdown-${n}`).html();o+=`\n            ${i}\n            <button type="button" name="add" class="btn btn-primary">${_x("button","Add")}</button>\n         `;const s=$("#kanban-modal");s.off("click",'button[name="add"]');s.off("click",'button[name="delete"]');s.on("click",'button[name="add"]',(()=>{const t=s.find('select[name="itemtype"]').val();const o=s.find('select[name="items_id"]').val();const i=s.find('select[name="role"]').val();if(t&&o){W(n,a,t,o,i).done((()=>{e.showCardPanel($(`#${n}-${a}`))}));h()}}));s.on("click",'button[name="delete"]',(t=>{const o=$(t.target).closest("li");const i=o.attr("data-itemtype");const s=o.attr("data-items-id");const l=o.closest("ul").attr("data-role");if(i&&s){K(n,a,i,s,l).done((()=>{e.showCardPanel($(`#${n}-${a}`))}));o.remove()}}));b(o,{card_el:t})};const W=(a,o,i,s,l)=>$.ajax({method:"POST",url:e.ajax_root+"kanban.php",data:{action:"add_teammember",itemtype:a,items_id:o,itemtype_teammember:i,items_id_teammember:s,role:l}}).done((()=>{e.refresh(null,null,(function(){n=window.setTimeout(t,e.background_refresh_interval*60*1e3)}),false)})).fail((()=>{glpi_toast_error(__("Failed to add team member"),__("Error"))}));const K=(a,o,i,s,l)=>$.ajax({method:"POST",url:e.ajax_root+"kanban.php",data:{action:"delete_teammember",itemtype:a,items_id:o,itemtype_teammember:i,items_id_teammember:s,role:l}}).done((()=>{e.refresh(null,null,(function(){n=window.setTimeout(t,e.background_refresh_interval*60*1e3)}),false)})).fail((()=>{glpi_toast_error(__("Failed to remove team member"),__("Error"))}));const H=function(t){$(e.element).trigger("kanban:pre_load_state");$.ajax({type:"GET",url:e.ajax_root+"kanban.php",data:{action:"load_column_state",itemtype:e.item.itemtype,items_id:e.item.items_id,last_load:e.last_refresh}}).done((function(n){if(n["state"]===undefined||n["state"]===null||Object.keys(n["state"]).length===0){if(t){t(false)}return}e.user_state={is_dirty:false,state:n["state"]};const a=Object.keys(n["state"]);for(let t=0;t<a.length;t++){const o=a[t];const i=n["state"][o];const s=$("#column-"+e.column_field.id+"-"+i.column);if(s.length===0){N(i.column,true,false)}$(e.element+" .kanban-columns .kanban-column:nth-child("+o+")").after(s);if(i.folded==="true"){s.addClass("collapsed")}}e.last_refresh=n["timestamp"];if(t){t(true);$(e.element).trigger("kanban:post_load_state")}}))};const q=function(t,n,a,o,i){$(e.element).trigger("kanban:pre_save_state");t=t!==undefined?t:false;if(!n&&!e.user_state.is_dirty){if(i){i()}return}if(t){R()}if(e.user_state.state===undefined||e.user_state.state===null||Object.keys(e.user_state.state).length===0){if(i){i()}return}$.ajax({type:"POST",url:e.ajax_root+"kanban.php",data:{action:"save_column_state",itemtype:e.item.itemtype,items_id:e.item.items_id,state:e.user_state.state}}).done((function(t,n,o){e.user_state.is_dirty=false;if(a){a(t,n,o);$(e.element).trigger("kanban:post_save_state")}})).fail((function(e,t,n){if(o){o(e,t,n)}})).always((function(){if(i){i()}}))};const B=function(){if(e.background_refresh_interval<=0){return}t=function(){const a=$(".sortable-placeholder");if(a.length>0){D();return}e.refresh(null,null,(function(){n=window.setTimeout(t,e.background_refresh_interval*60*1e3)}),false)};n=window.setTimeout(t,e.background_refresh_interval*60*1e3)};this.init=function(){$(e.element).data("js_class",e);$(e.element).trigger("kanban:pre_init");H((function(){i();$(document).ready((function(){$.ajax({type:"GET",url:e.ajax_root+"kanban.php",data:{action:"get_switcher_dropdown",itemtype:e.item.itemtype,items_id:e.item.items_id},success:function(t){const n=$(e.element+" .kanban-toolbar select[name='kanban-board-switcher']");n.replaceWith(t)}});_();B()}))}));$(e.element).trigger("kanban:post_init")};a(arguments)}})();